/*
 * @(#)OMClassFigure.java  1.0  1. Dezember 2003
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.diagrambsh;

import bsh.EvalError;
import ch.hslu.cm.oo.diagram.OMClassFigure;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import ch.hslu.cm.oo.*;
import ch.hslu.cm.oo.objectmodel.*;
import ch.hslu.cm.oo.objectmodelbsh.*;
import java.awt.*;
import java.awt.geom.*;
import java.io.IOException;
import java.util.*;
import javax.swing.*;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.undo.NonUndoableEdit;
/**
 * ClassFigureBsh visually represents a {@link OMBshClass}.
 * 
 * @author Werner Randelshofer
 * @version 1.0 1. Dezember 2003  Created.
 */
public class ClassFigureBsh extends OMClassFigure {
    @Override
    protected OMClass createSimulatedClass() {
        return new OMBshClass();
    }
    private OMBshClass getModelBsh() {
        return (OMBshClass) getModel();
    }

    private ObjectModelBsh getSimulationBsh() {
        return (ObjectModelBsh) getModel().getSimulation();
    }
    private ObjectModelBsh getSimulation() {
        return (ObjectModelBsh) getModel().getSimulation();
    }
    @Override
    public boolean handleDrop(Point2D.Double p, Collection<Figure> droppedFigures, DrawingView view) {
        if (droppedFigures.size() == 1) {
            Figure f = (Figure) droppedFigures.iterator().next();
            if (f instanceof DraggableMessageFigureBsh) {
                final DraggableMessageFigureBsh dmf = (DraggableMessageFigureBsh) f;
                
                if (getModel().getSimulatedClass() != null) {
                    final String operationName = dmf.getOperationName();
                    Object[] args;
                    try {
                        args = dmf.getArguments((ObjectModel) getModel().getSimulation());
                    } catch (IOException e) {
                        JOptionPane.showMessageDialog((Component) view, "Fehler in Nachricht", e.getMessage(), JOptionPane.ERROR_MESSAGE);
                        return true;
                    }
                    // Find a matching operation
                    ArrayList<OMOperation> operations = new ArrayList<OMOperation>(getModel().getSimulatedClass().getInvokableOperations());
                    OMOperation operation = null;
                    boolean matchingOperationFound = false;
                    for (Iterator i = operations.iterator(); i.hasNext(); ) {
                        operation = (OMOperation) i.next();
                        if (operation.getOperationName().equals(operationName)) {
                            if (args == null || args.length == operation.getParameterNames().length) {
                                matchingOperationFound = true;
                                break;
                            }
                        }
                    }
                    // Implementation note: When we don't find a matching
                    // operation, we proceed anyway. This is to trigger a
                    // DoesNotUnderstand Exception from the simulated object.
                    
                    
                    // Get arguments from user
                    if (matchingOperationFound && args == null) {
                        String[] parameterNames = operation.getParameterNames();
                        args = new Object[parameterNames.length];
                        if (parameterNames.length > 0) {
                            String[] wrappedArgs = ParameterDialog.show((Component) view, operation.getName(), parameterNames);
                            if (wrappedArgs == null) return true;
                            for (int i=0; i < args.length; i++) {
                                args[i] = getSimulation().unwrapValue(wrappedArgs[i]);
                            }
                        }
                    }
                    
                    final Object[] objArgs = (args == null) ? new Object[0] : args;
                    getModel().getSimulation().invokeBehaviour(new Worker() {
                        @Override
                        public Object construct() {
                            // TODO: Implement invokeMethod on OMBshClass.
                            /*
                            try {
                                //getModelBsh().invokeMethod(operationName, objArgs);
                                return Boolean.TRUE;
                            } catch (EvalError e) {
                                return e;
                            }*/
                            return false;
                        }
                        @Override
                        public void finished() {
                            Object value = getValue();
                            if (value instanceof Throwable) {
                                // to do: escalate to user
                                ((Throwable) value).printStackTrace();
                            }
                            fireUndoableEditHappened(new NonUndoableEdit());
                        }
                        
                    });
                }
                return true;
            }
        }
        return false;
    }

}